import json
from decimal import Decimal
from rest_framework import serializers
from .models import Agreement


class AgreementSerializer(serializers.ModelSerializer):
    shop = serializers.ListField(child=serializers.CharField(), required=False)

    class Meta:
        model = Agreement
        fields = [
            "id",
            "customer",
            "status",
            "meter_number",
            "shop",
            "advance",
            "rant",
            "service",
            "floor",
            "created_at",
            "updated_at",
        ]

    def create(self, validated_data):
        shop_data = validated_data.pop("shop", [])
        if isinstance(shop_data, str):
            try:
                shop_data = json.loads(shop_data)
            except json.JSONDecodeError:
                shop_data = []

        agreement = Agreement.objects.create(**validated_data)
        agreement.set_shop_list(shop_data)
        agreement.save()
        return agreement

    def update(self, instance, validated_data):
        instance.status = validated_data.get("status", instance.status)
        instance.advance = validated_data.get("advance", instance.advance)
        instance.rant = validated_data.get("rant", instance.rant)
        instance.service = validated_data.get("service", instance.service)
        instance.floor = validated_data.get("floor", instance.floor)
        
       
        instance.meter_number = validated_data.get("meter_number", instance.meter_number)

        shop_data = validated_data.get("shop")
        if shop_data is not None:
            if isinstance(shop_data, str):
                try:
                    shop_data = json.loads(shop_data)
                except json.JSONDecodeError:
                    shop_data = []
            instance.set_shop_list(shop_data)

        instance.save()
        return instance


    def to_representation(self, instance):
        data = super().to_representation(instance)
        # No change needed here for meter_number as it's a string
        data["advance"] = float(data["advance"]) if data["advance"] is not None else 0.0
        data["rant"] = float(data["rant"]) if data["rant"] is not None else 0.0
        data["service"] = float(data["service"]) if data["service"] is not None else 0.0

        return data