# Generated by Django 5.1.7 on 2025-05-07 11:15

from decimal import Decimal
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Finance',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('form_person', models.CharField(max_length=255)),
                ('to_person', models.CharField(max_length=255)),
                ('amount', models.DecimalField(decimal_places=2, max_digits=10)),
                ('description', models.TextField()),
                ('issue_date', models.DateField()),
                ('create_at', models.DateTimeField(auto_now_add=True)),
                ('update_at', models.DateTimeField(auto_now=True)),
            ],
            options={
                'verbose_name': 'Finance',
                'verbose_name_plural': 'Finances',
            },
        ),
        migrations.CreateModel(
            name='Unit',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('customer_name', models.CharField(blank=True, max_length=250, null=True, verbose_name='Occupier Name')),
                ('customer_father_name', models.CharField(blank=True, max_length=250, null=True, verbose_name="Occupier Father's Name")),
                ('unit_number', models.CharField(max_length=100, verbose_name='Unit Number')),
                ('services_description', models.TextField(blank=True, null=True, verbose_name='Services Description')),
                ('service_charge', models.DecimalField(decimal_places=2, default=Decimal('0.00'), max_digits=12, verbose_name='Default Service Charge')),
                ('current_water_reading', models.DecimalField(blank=True, decimal_places=2, default=Decimal('0.00'), max_digits=10, null=True, verbose_name='Current Water Meter Reading')),
                ('current_electricity_reading', models.DecimalField(blank=True, decimal_places=2, default=Decimal('0.00'), max_digits=10, null=True, verbose_name='Current Electricity Meter Reading')),
                ('status', models.CharField(choices=[('Occupied', 'Occupied'), ('Vacant', 'Vacant'), ('Maintenance', 'Maintenance')], default='Vacant', max_length=50, verbose_name='Status')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='Created At')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='Updated At')),
            ],
            options={
                'verbose_name': 'Unit',
                'verbose_name_plural': 'Units',
                'ordering': ['unit_number'],
            },
        ),
        migrations.CreateModel(
            name='UnitBill',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('month', models.PositiveSmallIntegerField(choices=[(1, 'حمل'), (2, 'ثور'), (3, 'جوزا'), (4, 'سرطان'), (5, 'اسد'), (6, 'سنبله'), (7, 'میزان'), (8, 'عقرب'), (9, 'قوس'), (10, 'جدی'), (11, 'دلو'), (12, 'حوت')], verbose_name='Month')),
                ('year', models.CharField(max_length=4, verbose_name='Year')),
                ('total', models.DecimalField(decimal_places=2, default=Decimal('0.00'), max_digits=14, verbose_name='Total Billed Service Charges')),
                ('unit_details_list', models.JSONField(default=dict, verbose_name='Unit Bill Details Snapshot')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
            options={
                'verbose_name': 'Unit Bill Period',
                'verbose_name_plural': 'Unit Bill Periods',
                'ordering': ['-year', '-month'],
                'unique_together': {('month', 'year')},
            },
        ),
    ]
