# Generated by Django 5.1.7 on 2025-04-11 07:28

from decimal import Decimal
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Staff',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=250, verbose_name='Name')),
                ('father_name', models.CharField(max_length=250, verbose_name='Father Name')),
                ('nic', models.CharField(blank=True, max_length=50, null=True, verbose_name='NIC')),
                ('photo', models.ImageField(blank=True, null=True, upload_to='staff/images')),
                ('address', models.CharField(blank=True, max_length=250, null=True, verbose_name='Address')),
                ('position', models.CharField(choices=[('Gard', 'Gard'), ('Cleaner', 'Cleaner'), ('Electrical', 'Electrical'), ('Manager', 'Manager'), ('Cooker', 'Cooker'), ('FinancialManager', 'Financial Manager')], max_length=250, verbose_name='Position')),
                ('salary', models.DecimalField(decimal_places=2, default=Decimal('0.00'), max_digits=12)),
                ('status', models.CharField(choices=[('Active', 'Active'), ('Inactive', 'Inactive')], max_length=250, verbose_name='Status')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='Created At')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='Updated At')),
            ],
            options={
                'verbose_name': 'Staff Member',
                'verbose_name_plural': 'Staff Members',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='Salary',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('month', models.PositiveSmallIntegerField(choices=[(1, 'حمل'), (2, 'ثور'), (3, 'جوزا'), (4, 'سرطان'), (5, 'اسد'), (6, 'سنبله'), (7, 'میزان'), (8, 'عقرب'), (9, 'قوس'), (10, 'جدی'), (11, 'دلو'), (12, 'حوت')], verbose_name='Month')),
                ('year', models.CharField(max_length=4, verbose_name='Year')),
                ('total', models.DecimalField(decimal_places=2, default=Decimal('0.00'), max_digits=14, verbose_name='Total Salary')),
                ('customers_list', models.JSONField(default=dict, verbose_name='Staff Salary Details')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
            options={
                'verbose_name': 'Salary Period',
                'verbose_name_plural': 'Salary Periods',
                'ordering': ['-year', '-month'],
                'unique_together': {('month', 'year')},
            },
        ),
    ]
