# Generated by Django 5.1.7 on 2025-04-21 06:24

import django.db.models.deletion
from decimal import Decimal
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('customers', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Unit',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('unit_number', models.CharField(max_length=100, unique=True, verbose_name='Unit Number/Name')),
                ('services', models.TextField(blank=True, null=True, verbose_name='Services Description')),
                ('unit_count', models.PositiveIntegerField(default=1, verbose_name='Unit Count/Size')),
                ('status', models.CharField(choices=[('Occupied', 'Occupied'), ('Vacant', 'Vacant'), ('Maintenance', 'Maintenance')], default='Vacant', max_length=50, verbose_name='Status')),
                ('water_meter', models.CharField(blank=True, max_length=100, null=True, verbose_name='Water Meter ID')),
                ('electricity_meter', models.CharField(blank=True, max_length=100, null=True, verbose_name='Electricity Meter ID')),
                ('monthly_charge', models.DecimalField(decimal_places=2, default=Decimal('0.00'), max_digits=12, verbose_name='Monthly Charge')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='Created At')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='Updated At')),
                ('customer', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='units', to='customers.customer', verbose_name='Customer')),
            ],
            options={
                'verbose_name': 'Unit',
                'verbose_name_plural': 'Units',
                'ordering': ['unit_number'],
            },
        ),
        migrations.CreateModel(
            name='UnitBill',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('month', models.PositiveSmallIntegerField(choices=[(1, 'January'), (2, 'February'), (3, 'March'), (4, 'April'), (5, 'May'), (6, 'June'), (7, 'July'), (8, 'August'), (9, 'September'), (10, 'October'), (11, 'November'), (12, 'December')], verbose_name='Month')),
                ('year', models.CharField(max_length=4, verbose_name='Year')),
                ('total_bill', models.DecimalField(decimal_places=2, default=Decimal('0.00'), max_digits=14, verbose_name='Total Bill Amount')),
                ('units_list', models.JSONField(default=dict, verbose_name='Unit Bill Details')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
            options={
                'verbose_name': 'Unit Bill Period',
                'verbose_name_plural': 'Unit Bill Periods',
                'ordering': ['-year', '-month'],
                'unique_together': {('month', 'year')},
            },
        ),
    ]
