# Generated by Django 5.1.7 on 2025-04-21 07:01

import django.db.models.deletion
from decimal import Decimal
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('customers', '0001_initial'),
        ('units', '0001_initial'),
    ]

    operations = [
        migrations.RemoveField(
            model_name='unitbill',
            name='total_bill',
        ),
        migrations.RemoveField(
            model_name='unitbill',
            name='units_list',
        ),
        migrations.AddField(
            model_name='unitbill',
            name='total_billed',
            field=models.DecimalField(decimal_places=2, default=Decimal('0.00'), help_text='Sum of monthly charges of all units included in this bill period at the time of generation.', max_digits=14, verbose_name='Total Billed Amount'),
        ),
        migrations.AddField(
            model_name='unitbill',
            name='unit_details',
            field=models.JSONField(default=dict, help_text='Snapshot of billable unit details for this period (Unit ID as key).', verbose_name='Unit Bill Details'),
        ),
        migrations.AlterField(
            model_name='unit',
            name='customer',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='units', to='customers.customer', verbose_name='Current Customer'),
        ),
        migrations.AlterField(
            model_name='unit',
            name='monthly_charge',
            field=models.DecimalField(decimal_places=2, default=Decimal('0.00'), help_text='The standard monthly rent/fee for this unit.', max_digits=12, verbose_name='Monthly Charge'),
        ),
        migrations.AlterField(
            model_name='unit',
            name='services',
            field=models.TextField(blank=True, help_text='Description of services included or specific details about the unit.', null=True, verbose_name='Services Description'),
        ),
        migrations.AlterField(
            model_name='unit',
            name='status',
            field=models.CharField(choices=[('Occupied', 'Occupied'), ('Vacant', 'Vacant'), ('Maintenance', 'Maintenance')], default='Vacant', help_text='Occupied (Customer assigned), Vacant (No customer), Maintenance (Temporarily unavailable)', max_length=50, verbose_name='Status'),
        ),
        migrations.AlterField(
            model_name='unit',
            name='unit_count',
            field=models.PositiveIntegerField(default=1, help_text='e.g., number of rooms or a general size indicator.', verbose_name='Unit Count/Size'),
        ),
        migrations.AlterField(
            model_name='unit',
            name='unit_number',
            field=models.CharField(help_text="A unique identifier for the unit (e.g., 'A-101', 'Shop 5')", max_length=100, unique=True, verbose_name='Unit Number/Name'),
        ),
    ]
