from django.db import models
from django.utils.translation import gettext_lazy as _


# Create your models here.
class Customer(models.Model):
    name = models.CharField(max_length=255)
    father_name = models.CharField(max_length=255)
    phone_number = models.IntegerField(_("Phone Number"))
    rental_owner = models.CharField(max_length=255)
    image = models.ImageField(upload_to="media/images")
    nic = models.CharField(_("NIC"), max_length=50)
    address = models.CharField(_("Address"), max_length=250)

    def __str__(self):
        return f"Customer: {self.name}, Father: {self.father_name}."
