from django.db import models
from django.db.models import Sum
from django.utils.translation import gettext_lazy as _


class Expenditure(models.Model):

    EXPENDITURE_CHOICES = (
        ("Second Floor", "Second Floor"),
        ("Third Floor", "Third Floor"),
        ("general", "general"),
        ("Other", "Other"),
    )
    MONTH_CHOICES = (
        (1, "حمل"),
        (2, "ثور"),
        (3, "جوزا"),
        (4, "سرطان"),
        (5, "اسد"),
        (6, "سنبله"),
        (7, "میزان"),
        (8, "عقرب"),
        (9, "قوس"),
        (10, "جدی"),
        (11, "دلو"),
        (12, "حوت"),
    )
# add new 
    floor = models.CharField(choices=EXPENDITURE_CHOICES, max_length=20)
    amount = models.DecimalField(max_digits=12, decimal_places=2, default=0.0)
    year = models.CharField(max_length=255)
    description = models.TextField()
    month = models.CharField(_("Month"), choices=MONTH_CHOICES, max_length=250)
    receiver = models.CharField(max_length=255)
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)

    def __str__(self):
        return str(f"{self.take_name} - {self.floor}")

    @classmethod
    def calculate_total_amount(cls):
        total = cls.objects.aggregate(Sum("amount"))
        return total["amount__sum"] if total["amount__sum"] is not None else 0.0


class Income(models.Model):
    MONTH_CHOICES = (
        (1, "حمل"),
        (2, "ثور"),
        (3, "جوزا"),
        (4, "سرطان"),
        (5, "اسد"),
        (6, "سنبله"),
        (7, "میزان"),
        (8, "عقرب"),
        (9, "قوس"),
        (10, "جدی"),
        (11, "دلو"),
        (12, "حوت"),
    )

    source = models.CharField(max_length=550)
    amount = models.DecimalField(max_digits=12, decimal_places=2, default=0.0)
    description = models.TextField()
    year = models.CharField(max_length=255)
    month = models.CharField(_("Month"), choices=MONTH_CHOICES, max_length=250)
    receiver = models.CharField(max_length=255)
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)

    def __str__(self):
        return str(f"{self.take_name} - {self.floor}")

    @classmethod
    def calculate_total_amount(cls):
        total = cls.objects.aggregate(Sum("amount"))
        return total["amount__sum"] if total["amount__sum"] is not None else 0.0
